/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.model.BackpackBlockModel;
import com.tiviacz.travelersbackpack.client.model.BackpackLayerModel;
import com.tiviacz.travelersbackpack.common.recipes.BackpackDyeRecipe;
import com.tiviacz.travelersbackpack.init.ModItems;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import com.tiviacz.travelersbackpack.util.RenderUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Triple;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    public TravelersBackpackLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderer) {
        super(renderer);
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, AbstractClientPlayer clientPlayer, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (TravelersBackpack.enableCurios()) {
            return;
        }
        if (CapabilityUtils.isWearingBackpack((Player)clientPlayer)) {
            ItemStack stack = CapabilityUtils.getWearingBackpack((Player)clientPlayer);
            TravelersBackpackLayer.renderBackpackLayer(BackpackLayerModel.LAYER_MODEL, (HumanoidModel)this.m_117386_(), poseStack, bufferIn, packedLightIn, (LivingEntity)clientPlayer, stack, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
        }
    }

    public static void renderBackpackLayer(BackpackLayerModel model, HumanoidModel humanoidModel, PoseStack poseStack, MultiBufferSource bufferIn, int packedLightIn, LivingEntity livingEntity, ItemStack stack, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Visibility") && !stack.m_41783_().m_128471_("Visibility")) {
            return;
        }
        model.setLivingEntity(livingEntity);
        model.setMultiBufferSource(bufferIn);
        Item item = stack.m_41720_();
        if (!(item instanceof TravelersBackpackItem)) {
            return;
        }
        TravelersBackpackItem travelersBackpackItem = (TravelersBackpackItem)item;
        boolean translucentLayer = travelersBackpackItem == ModItems.QUARTZ_TRAVELERS_BACKPACK.get() || travelersBackpackItem == ModItems.SNOW_TRAVELERS_BACKPACK.get();
        ResourceLocation loc = travelersBackpackItem.getBackpackTexture();
        VertexConsumer vertexConsumer = bufferIn.m_6299_(translucentLayer ? RenderType.m_110470_((ResourceLocation)loc) : RenderType.m_110446_((ResourceLocation)loc));
        poseStack.m_85836_();
        TravelersBackpackLayer.alignModel(poseStack, humanoidModel, model, livingEntity);
        if (BackpackDyeRecipe.hasColor(stack) && travelersBackpackItem == ModItems.STANDARD_TRAVELERS_BACKPACK.get()) {
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed.png");
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110446_((ResourceLocation)loc));
            Triple<Float, Float, Float> rgb = RenderUtils.intToRGB(BackpackDyeRecipe.getColor(stack));
            model.mainBody.m_104306_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, ((Float)rgb.getLeft()).floatValue(), ((Float)rgb.getMiddle()).floatValue(), ((Float)rgb.getRight()).floatValue(), 1.0f);
            loc = new ResourceLocation("travelersbackpack", "textures/model/dyed_extras.png");
            vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        }
        model.m_7695_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        int sleepingBagColor = stack.m_41782_() && stack.m_41783_().m_128441_("SleepingBagColor") ? stack.m_41783_().m_128451_("SleepingBagColor") : DyeColor.RED.m_41060_();
        loc = BackpackBlockModel.getSleepingBagTexture(sleepingBagColor);
        vertexConsumer = bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)loc));
        model.sleepingBag.m_104306_(poseStack, vertexConsumer, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static void alignModel(PoseStack poseStack, HumanoidModel parent, BackpackLayerModel backpackModel, LivingEntity livingEntity) {
        if (livingEntity.m_6047_()) {
            poseStack.m_85837_(0.0, -0.155, 0.025);
        }
        parent.m_102872_((HumanoidModel)backpackModel);
        backpackModel.setupAngles(parent);
        poseStack.m_85837_(0.0, 0.175, 0.325);
        poseStack.m_85841_(0.85f, 0.85f, 0.85f);
        if (livingEntity.m_6162_()) {
            poseStack.m_252880_(0.0f, 0.8f, -0.165f);
            float scaleFactor = livingEntity.m_6134_();
            poseStack.m_85841_(scaleFactor + 0.1f, scaleFactor + 0.1f, scaleFactor + 0.1f);
        }
    }
}

